var scale = 'c';
var zip = 95014;
var xmlRequest = null;
var refreshTimer = null;
var refreshTime = 1000 * 60 * 60;
var lastRefresh = null;
var anim = false;
var rot = 0;

function translate(temp) {
    var n = parseInt(temp);
    if(scale === 'f')
        return n;
    else if(scale === 'c')
        return Math.round((n - 32) * (5 / 9));
    else if(scale === 'k')
        return Math.round((n - 32) * (5 / 9) + 273.15);
    else if(scale === 'r')
        return n + 460;
    else if(scale === 're')
        return Math.round((n - 32) * (4 / 9));
    else if(scale === 'b')
        return 451 - n;
    return n;
}

function startXMLRequest() {
    if(xmlRequest) {
        xmlRequest.abort();
        xmlRequest = null;
    }
    
    if(refreshTimer != null) {
        clearTimeout(refreshTimer);
        refreshTimer = null;
    }
    
    xmlRequest = new XMLHttpRequest();
    xmlRequest.onreadystatechange = XMLRequestChange;
    var url = "http://www.weather.gov/forecasts/xml/SOAP_server/ndfdXMLclient.php"
        + "?whichClient=NDFDgenMultiZipCode&zipCodeList=" + zip
        + "&product=time-series&temp=temp&maxt=maxt&mint=mint&sky=sky&pop12=pop12";
    //alert(url);
    xmlRequest.open("GET", url, true);
    xmlRequest.send("");
    
    startRefreshAnim();
    refreshTimer = setTimeout(startXMLRequest, refreshTime);
}

function XMLRequestChange() {
    var wData = createNullWeather();
    
    if(xmlRequest.readyState == 4) {
        stopRefreshAnim();
        if(xmlRequest.status == 200)
            parseXML(xmlRequest.responseText);
        else
            document.getElementById("currentTemp").innerHTML = "ERR";
    }
}

function parseXML(text) {
    var weather = createNullWeather();

    var parser = new DOMParser();
    var xml = parser.parseFromString(text,"text/xml");
    
    var temps = xml.getElementsByTagName("temperature");

    weather = setDays(weather, xml);

    weather[0].temp = getCurrentTemp(temps);

    weather = setHighs(weather, temps);
    weather = setLows(weather, temps);
    
    weather = setSun(weather, xml);
    weather = setRain(weather, xml);

    displayWeather(weather);
    updateStatus();
    
    var time = new Date();
    lastRefresh = time.getTime();
}

function setDays(weather, xml) {
    var layouts = xml.getElementsByTagName("time-layout");
    var today = null;
    for(var i = 0; i < layouts.length; i++) {
        var name = layouts[i].getElementsByTagName("layout-key")[0].childNodes[0].nodeValue;
        if(name.substring(0, 6) === "k-p24h")
            today = layouts[i].getElementsByTagName("end-valid-time")[0].childNodes[0].nodeValue;
    }
    
    if(today == null)
        today = new Date();
    else
        today = new Date(today.substring(0, 4), today.substring(5, 7) - 1, today.substring(8, 10) - 1);
        
    var day = today.getDay();
    var days = ["SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT"];
    
    for(var i = 0; i < 5; i++) {
        weather[i].day = days[day];
        day += 1;
        if(day > 6)
            day = 0;
    }
    
    return weather;
}

function getCurrentTemp(temps) {
    for(var i = 0; i < temps.length; i++) {
        var name = temps[i].getElementsByTagName("name")[0].childNodes[0].nodeValue;
        if(name === "Temperature") {
            return translate(temps[i].
                getElementsByTagName("value")[0].childNodes[0].nodeValue);
        }
    }
    return null;
}

function setHighs(weather, temps) {
    var high = null;
    for(var i = 0; i < temps.length; i++) {
        var name = temps[i].getElementsByTagName("name")[0].childNodes[0].nodeValue;
        if(name === "Daily Maximum Temperature")
            high = temps[i];
    }
    
    if(high == null)
        return weather;
    
    var values = high.getElementsByTagName("value");
    for(var i = 0; i < 5; i++) {
        var val = values[i].childNodes[0].nodeValue;
        if(val)
            weather[i].high = translate(val);
    }
    
    return weather;
}

function setLows(weather, temps) {
    var low = null;
    for(var i = 0; i < temps.length; i++) {
        var name = temps[i].getElementsByTagName("name")[0].childNodes[0].nodeValue;
        if(name === "Daily Minimum Temperature")
            low = temps[i];
    }
    
    if(low == null)
        return weather;
    
    var values = low.getElementsByTagName("value");
    for(var i = 0; i < 5; i++) {
        var val = values[i].childNodes[0].nodeValue;
        if(val)
            weather[i].low = translate(val);
    }
    
    return weather;
}

function setSun(weather, xml) {
    var coverage = xml.getElementsByTagName("cloud-amount")[0].getElementsByTagName("value");
    
    for(var i = 0; i < 5; i++) {
        if(i * 8 > coverage.length)
            break;
        var e = coverage[i * 8];
        if(!e)
            continue;
        var c = Math.floor(parseInt(e.childNodes[0].nodeValue) / 25);
        if(c > 3)
            c = 3;
        weather[i].sun = c;
    }
    
    return weather;
}

function setRain(weather, xml) {
    var rain = xml.getElementsByTagName("probability-of-precipitation")[0].getElementsByTagName("value");
    
    for(i = 0; i < 5; i++) {
        if(i * 2 > rain.length)
            break;
        var e = rain[i * 2];
        if(!e)
            continue;
        weather[i].rain = parseInt(e.childNodes[0].nodeValue) / 100;
    }
    
    return weather;
}

function createNullWeather() {
    var ret = new Array(5);
    for(var i = 0; i < 5; i++)
        ret[i] = {day:"&mdash;", temp:null, high:"&mdash;", low:"&mdash;", sun:null, rain:0};
    return ret;
}

function displayWeather(data) {
    for(var i = 0; i < 5; i++)
        displayDay(i + 1, data[i]);
}

function displayDay(day, data) {
    document.getElementById("date" + day).innerHTML = data.day;
    document.getElementById("high" + day).innerHTML = data.high;
    document.getElementById("low" + day).innerHTML = data.low;
    var sun = document.getElementById("icon" + day);
    if(data.sun == null)
        sun.style.display = "none";
    else {
        sun.style.display = "block";
        sun.src = "Images/sun" + data.sun + ".png";
    }
    var driz = document.getElementById("driz" + day);
    var rain = document.getElementById("rain" + day);
    driz.style.opacity = data.rain > 0.2 ? 1 : 0;
    rain.style.opacity = data.rain > 0.6 ? 1 : 0;
    //driz.style.opacity = Math.min(1, data.rain * 2);
    //rain.style.opacity = Math.max(0, data.rain * 2 - 1);
    if(day == 1) {
        var current = document.getElementById("currentTemp");
        if(data.temp != null)
            current.innerHTML = data.temp;
        else
            current.innerHTML = "&mdash;";
    }
}

function updateStatus() {
    var now = new Date();
    var hours = now.getHours();
    if(hours < 10)
        hours = "0" + hours.toString();
    var minutes = now.getMinutes();
    if(minutes < 10)
        minutes = "0" + minutes.toString();
    var stamp = hours + ":" + minutes;
    document.getElementById("status").innerHTML = "zip: " + zip + "<br>refreshed: " + stamp;
}

function startRefreshAnim() {
    anim = true;
    refreshAnim();
}

function stopRefreshAnim() {
    anim = false;
}

function refreshAnim() {
    rot += 15;
    if(rot > 360)
        rot -= 360;
    
    var r = document.getElementById("refresh");
    if(!anim) {
        rot = 0;
        r.className = "norm";
    }
    else
        r.className = "vis";
    
    document.getElementById("refresh_ico").style.webkitTransform = "rotate(" + rot + "deg)";
    
    if(anim)
        setTimeout(refreshAnim, 1000 / 30);
}
